#exec AUDIO IMPORT FILE="Sounds\GrappleHit.WAV" NAME="GrappleHit" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\GrapplePull.WAV" NAME="GrapplePull" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\GrappleEnd.WAV" NAME="GrappleEnd" GROUP="Weapons"

class Respawnables_Projectile_Grapple expands Respawnables_Projectile;

var vector pullDest;
var vector hNormal;
var bool bRight, bCenter;
var int grappleSpeed;
var float timeBetweenHit;
var float hitDamage;
var bool bPlaySound;
var bool bAttachedToThing;
var bool bDoAttachPawn;
var bool bLineOfSight;

var Actor thing;
var float totalTime;
var Respawnables_Weapon_GrapplingHook master;
var bool bThingPawn;

replication
{
  unreliable if (Role == ROLE_Authority) master, bThingPawn, thing, totalTime, pullDest, hNormal;
}


simulated function Destroyed()
{
	master.Grapple=none;
	AmbientSound=none;
	Instigator.AmbientSound=None;
	PlaySound(sound'GrappleEnd',SLOT_Misc,10.0);
	Instigator.PlaySound(sound'GrappleEnd',SLOT_Misc,10.0);
	Instigator.setPhysics(PHYS_Falling);
  Super.Destroyed();
  
}

simulated function SetMaster(Respawnables_Weapon_GrapplingHook w)
{
	master=w;
}

auto state Flying
{
	
	simulated function ProcessTouch(Actor Other, Vector HitLocation)
	{
		//should be implemented in subclass
		//log("I'm in Process Touch. I've never been here before");
		if (Inventory(Other) != none)
  	{
    	Inventory(Other).GiveTo(Instigator);
    }
    Instigator.AmbientSound=None;
    AmbientSound=None;
		destroy();
		return;
	}
	
	simulated function HitWall (vector HitNormal, actor Wall)
	{
			AmbientSound=sound'GrappleEnd';
			Instigator.AmbientSound=sound'GrapplePull';
			bPlaySound=true;
			pullDest = Location;
			hNormal = HitNormal;
			SetPhysics(PHYS_None);
			
			
			if(Wall.IsA('Pawn') || Wall.IsA('Mover')){
				if(!bDoAttachPawn && !Wall.IsA('Mover')){
					destroy();
					return;
				}
				bAttachedToThing=true;
				thing=Wall;
				if(Wall.IsA('Pawn'))
					bThingPawn=true;
				GotoState('PullTowardDynamic');	
			}
			else
				GotoState('PullTowardStatic');
	}


	simulated function BeginState()
	{
		Velocity = vector(Rotation) * speed;	
	}
}

state() PullTowardStatic
{
	simulated function Tick(float deltaTime)
	{
		local float speed;
		local vector v;
		speed = vSize(Instigator.Velocity);
		if(bLineofSight && !Instigator.LineOfSightTo(Self)){
			destroy();
			return;
		}
		
		if(vSize(Instigator.Location - pullDest)<=50)
		{
			Instigator.setPhysics(PHYS_None);
			AmbientSound=none;
			Instigator.AmbientSound=none;
			Instigator.PlaySound(sound'GrappleEnd',SLOT_Misc,0);
			Instigator.AddVelocity(Instigator.Velocity * -1);
			bPlaySound=false;
		}
		else {
			Instigator.Velocity = (normal(pullDest - Instigator.Location) * grappleSpeed);
		}
	}
	
	simulated function ProcessTouch(Actor Other, Vector HitLocation)
	{
		Instigator.AmbientSound=None;
    AmbientSound=None;
		destroy();
	}
	
	simulated function BeginState()
	{
		Instigator.Velocity = (normal(pullDest - Instigator.Location) * grappleSpeed);
		Instigator.SetPhysics(PHYS_Falling);
		totalTime=0.0;
	}
}

state() PullTowardDynamic
{
	
	simulated function Tick(float deltaTime)
	{
		local float speed;
		local vector v;
		speed = vSize(Instigator.Velocity);
		if(bLineofSight && !Instigator.LineOfSightTo(Self)){
			destroy();
			return;
		}
		
	
		pullDest=thing.Location;
		SetLocation(pullDest);
				
		if(bThingPawn) {
			totalTime = totalTime + deltaTime;
			if(totalTime>timeBetweenHit){
				v.x=0;
				v.y=0;
				v.z=0;
				Pawn(thing).TakeDamage(hitDamage, instigator, v, v, 'Grappled');
				totalTime= totalTime - timeBetweenHit;
			}
			if(Pawn(thing).health<=0){
				Instigator.setPhysics(PHYS_Falling);
				destroy();
				return;
			}
		}
		
		
		if(vSize(Instigator.Location - pullDest)<=50)
		{
			Instigator.setPhysics(PHYS_Falling);
			AmbientSound=none;
			Instigator.AmbientSound=none;
			Instigator.PlaySound(sound'GrappleEnd',SLOT_Misc,0);
			Instigator.AddVelocity(Instigator.Velocity * -1);
			bPlaySound=false;
		}
		
		else
		{
			if(!bPlaySound){
				AmbientSound=sound'GrapplePull';
				Instigator.AmbientSound=sound'GrapplePull';
				bPlaySound=true;
			}
			Instigator.Velocity = (normal(pullDest - Instigator.Location) * grappleSpeed);
			//Instigator.AddVelocity(Instigator.Velocity * -1); //Kill all other Velocity first
			//Instigator.AddVelocity(normal(pullDest - Instigator.Location) * grappleSpeed); 		
		}
	}
	
	simulated function ProcessTouch(Actor Other, Vector HitLocation)
	{
		Instigator.AmbientSound=None;
    AmbientSound=None;
		destroy();
	}
	
	simulated function BeginState()
	{
		Instigator.SetPhysics(PHYS_Falling);
		totalTime=0.0;
	}
}

defaultproperties
{
    grappleSpeed=1300
    timeBetweenHit=0.50
    hitdamage=5.00
    bDoAttachPawn=True
    bLineOfSight=True
    speed=2000.00
    MaxSpeed=4000.00
    bNetTemporary=False
    LifeSpan=60.00
    Texture=Texture'UMenu.Icons.Bg41'
    Mesh=LodMesh'UnrealShare.GrenadeM'
    bUnlit=True
    bMeshEnviroMap=True
    bBlockActors=True
    bBlockPlayers=True
}
